---
generated_at: 2026-02-02 10:25:00
metrics:
  claims_total: 13
  claims_with_evidence: 11
  claims_without_evidence: 2
confidence_derived: 0.85
---

# 根拠レポート：26-cuDNN RNN

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.85**
  - 根拠あり：11 / 13、根拠なし：2
- 優先レビュー（高）
  1. **Keras自動cuDNN選択条件の詳細**：KerasのLSTM/GRU内部ロジック未確認
  2. **CudnnRNNV3のnum_proj実装**：ccファイル後半未確認

## 2) 参照した情報（Evidence一覧）
- E-01: `tensorflow/core/ops/cudnn_rnn_ops.cc` 行24-33（属性定数定義）
- E-02: `tensorflow/core/ops/cudnn_rnn_ops.cc` 行40-63（CudnnRNNParamsSize）
- E-03: `tensorflow/core/ops/cudnn_rnn_ops.cc` 行65-111（CudnnRNN）
- E-04: `tensorflow/core/ops/cudnn_rnn_ops.cc` 行113-150（CudnnRNNV2）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` 行27

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | rnn_mode: lstm/gru/rnn_relu/rnn_tanh | E-01 (行24-25) | ○ |
| C-02 | input_mode: linear_input/skip_input/auto_select | E-01 (行27-29) | ○ |
| C-03 | direction: unidirectional/bidirectional | E-01 (行31-32) | ○ |
| C-04 | T: bfloat16/float16/float32/float64 | E-03 (行75) | ○ |
| C-05 | CudnnRNNParamsSize入力はスカラー3つ | E-02 (行41-43, 57-59) | ○ |
| C-06 | CudnnRNN入力形状検証（3D, 3D, _, 1D） | E-03 (行87-89) | ○ |
| C-07 | bidirectional時output_size = num_units*2 | E-03 (行99-101) | ○ |
| C-08 | LSTM以外はoutput_cが空 | E-03 (行104-105) | ○ |
| C-09 | V2でhost_reserved出力追加 | E-04 (行123) | ○ |
| C-10 | SetIsStateful | E-03 (行70) | ○ |
| C-11 | dropout/seed/seed2/is_training属性 | E-03 (行79-82) | ○ |
| C-12 | Keras LSTM/GRUからの自動cuDNN選択条件 | **根拠不足** | △ |
| C-13 | V3のnum_proj射影サイズ | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- Kerasレイヤーの自動cuDNN選択ロジックはrecurrent.py内のLSTM/GRUクラスに実装されているが詳細未確認
  - 候補：`tensorflow/python/keras/layers/recurrent.py` LSTM/GRUクラス定義
- CudnnRNNV3のOp定義はcudnn_rnn_ops.ccの150行目以降にあるが読み込み範囲外
  - 候補：`tensorflow/core/ops/cudnn_rnn_ops.cc` 行150以降

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - cuDNN自動選択条件とV3の詳細は追加確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] Keras LSTM/GRUのcuDNN自動選択条件が正確に記載されているか
- [ ] CudnnRNNV3のnum_proj動作が正しいか
- [ ] Backprop Op群の入出力が設計書と一致するか
